#ifndef ZMULTIPLE_FILES_EXPORT_INCLUDED
#define ZMULTIPLE_FILES_EXPORT_INCLUDED
//----------------------------------------------------------------
// This file provides some declarations one can use in the filer
// to allow it perform multiple files exporting.
//----------------------------------------------------------------


//----------------------------------------------------------------
// Filter have to provide an exported function:
//      DWORD CALLBACK MultipleExportInfo(DWORD num)
// that returns bitwise-or combination of flags, that describes
// exporting of format specified by <num>. It should return 0 when
// there is no more supported formats.
//   The following flags can be returned:
#define ZMULTIPLE_FILES_EXPORT_NEED_PREPARE   0x00000001
#define ZMULTIPLE_FILES_EXPORT_NEED_FINALCALL 0x00000002
#define ZMULTIPLE_FILES_EXPORT_NEED_FILES     0x00000004
#define ZMULTIPLE_FILES_EXPORT_NEED_ONEOBJECT 0x00000008 //can't be used with "GROUPS".

#define ZMULTIPLE_FILES_EXPORT_PARTIALLY      0x00000010
#define ZMULTIPLE_FILES_EXPORT_SELECTED     ( 0x00000020 | ZMULTIPLE_FILES_EXPORT_PARTIALLY )
#define ZMULTIPLE_FILES_EXPORT_VISIBLE      ( 0x00000040 | ZMULTIPLE_FILES_EXPORT_PARTIALLY )
#define ZMULTIPLE_FILES_EXPORT_ENABLED      ( 0x00000080 | ZMULTIPLE_FILES_EXPORT_PARTIALLY )
#define ZMULTIPLE_FILES_EXPORT_GROUPS         0x00000100
#define ZMULTIPLE_FILES_EXPORT_NEEDGROUPS     0x00000200 //unsupported yet.
#define ZMULTIPLE_FILES_EXPORT_HIERARCHIES    0x00000400

//----------------------------------------------------------------
// Filter have to provide a "Title" function:
//     char* CALLBACK MultipleExportTitle(DWORD num)

//----------------------------------------------------------------
// Filter can provide an "explanation" function:
//     char* CALLBACK MultipleExportHint(DWORD num)
// eg:
//char* CALLBACK MultipleExportHint(DWORD num)
//{
//  if (num == 0) return "Select objects in the list that will define groups.";
//  return NULL;
//}


//----------------------------------------------------------------
// If your filter has specified ZMULTIPLE_FILES_EXPORT_GROUPS bit
// in MultipleExportHint function, it have to provide a "mask":
//     char* CALLBACK MultipleExportMask(DWORD num)
// where %file% specificator can be used to show what part of
// the name to use as the file's name.
// '?' - replaces single character
// '*' - replaces any amount of characters
// %file.n% sintax can be used to specify limited length of file name.
//
// Limitation: Both "*%file%" and "%file%*" specificators are invalid.
//             Both "*%file.n%" and "%file.n%*" are not supported yet.
// Example:
//char* CALLBACK MultipleExportMask(DWORD num)
//{
//  if (num == 0)
//    return "%file%[*]";
//    // will match track[0] and track[1] into single file "track"
//  if (num == 1)
//    return "*%file.5%_*";
//    // will match mytrack_road and track_grass into single file "track"
//  return NULL;
//}

//----------------------------------------------------------------
// ExportingFunctions have can have one of the following header:
typedef DWORD  (CALLBACK *MULTIPLE_EXPORT_NAME_SET)(char* pFileName, tObjectSet* pSet, CDirect3D* pD3D);
typedef DWORD  (CALLBACK *MULTIPLE_EXPORT_FILE_SET)(CFile* pFile, tObjectSet* pSet, CDirect3D* pD3D);
typedef DWORD  (CALLBACK *MULTIPLE_EXPORT_NAME_OBJ)(char* pFileName, tObject* pObj, CDirect3D* pD3D);
typedef DWORD  (CALLBACK *MULTIPLE_EXPORT_FILE_OBJ)(CFile* pFile, tObject* pObj, CDirect3D* pD3D);
//ZMULTIPLE_FILES_EXPORT_HIERARCHIES uses MULTIPLE_EXPORT_NAME_SET;

#endif /* ZMULTIPLE_FILES_EXPORT_INCLUDED */
